﻿using log4net;
using System;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.IWS.MappingService.Interface;
using VA.PPMS.IWS.MappingService.Mappers;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.MappingService
{
    public class MappingService : IMappingService
    {
        private readonly ILog _logger;
        private readonly MapProviderToCrm _providerMapper;

        public MappingService(ILog logger, MapProviderToCrm providerMapper)
        {
            _logger = logger;
            _providerMapper = providerMapper;
        }

        public async Task<MapperResult> MapAsync(Providers providers)
        {
            try
            {
                _logger.Info($"@@@@ INFO - Start MapAsync for TransactionId: {providers.TransactionId}, Provider: {providers.InitialProviderId} @@@@");
                var results = await MapProviderToAccount(providers);
                _logger.Info($"@@@@ INFO - End MapAsync for TransactionId: {providers.TransactionId} @@@@");

                return results;
            }
            catch (Exception ex)
            {
                _logger.Error($"@@@@ ERROR - There was a problem Mapping Add/Update Providers for TransactionId: {providers.TransactionId} @@@@", ex);
                throw;
            }
        }
        
        private async Task<MapperResult> MapProviderToAccount(Providers providers)
        {
            if (providers.Provider.Count < 1) return new MapperResult();

            var results = new MapperResult();

            foreach (var provider in providers.Provider)
            {
                try
                {
                    results.Add(await _providerMapper.Map(provider, providers.NetworkId, providers.IsVaNetwork));
                }
                catch (Exception ex)
                {
                    results.Add(new MapperResultDetail { ValidationMessage = ex.Message });
                }
            }

            return results;
        }
    }
}